;----------------------------------------------------------------------------
; Nintendo Entertainment System
; Jnes 1.0.2
; by Acidnine
; 1.0
;
; Notes:
;
; The only thing this emulator is lacking in is command-line
; customizability. Which is why I made this...
;
; This script will wait for Jnes to be the active window, then send
; alt+enter to full-screen it. When you press Escape, it will close
; Jnes and return to Hyperspin.
;
;----------------------------------------------------------------------------

Run, %executable% "%romPath%%romName%%romExtension%", %emuPath%, UseErrorLevel

;When escape is pressed, the emulator will close; do this before going full-screen
Hotkey, ESCAPE, CloseJnes

;Wait for emulator to be active then send alt+enter to full-screen it
WinWaitActive, Jnes
Send !{Enter}

if (ErrorLevel = 0){
    Process, waitClose, %executable%
}else{
    MsgBox, 48, Error,Failed to run executable,6
}

ExitApp

CloseProcess:
return

CloseJnes:
Process, Close, %executable%
Hotkey, ESCAPE, off
return